<?php
// settings.php
session_start();
require_once 'config.php';

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $client_id = $_POST['client_id'] ?? '';
    $client_secret = $_POST['client_secret'] ?? '';
    $api_user = $_POST['api_user'] ?? '';
    $api_password = $_POST['api_password'] ?? '';
    
    if (empty($client_id) || empty($client_secret) || empty($api_user) || empty($api_password)) {
        $error = "All fields are required!";
    } else {
        try {
            $db = getDB();
            
            // Check if settings already exist
            $checkStmt = $db->prepare("SELECT id FROM contabo_settings LIMIT 1");
            $checkStmt->execute();
            
            if ($checkStmt->fetch()) {
                // Update existing settings
                $stmt = $db->prepare("UPDATE contabo_settings SET client_id = ?, client_secret = ?, api_user = ?, api_password = ? WHERE id = 1");
            } else {
                // Insert new settings
                $stmt = $db->prepare("INSERT INTO contabo_settings (client_id, client_secret, api_user, api_password) VALUES (?, ?, ?, ?)");
            }
            
            $stmt->execute([$client_id, $client_secret, $api_user, $api_password]);
            $message = "Settings saved successfully!";
            
        } catch(PDOException $e) {
            $error = "Database error: " . $e->getMessage();
        }
    }
}

// Load existing settings
$settings = [];
try {
    $db = getDB();
    $stmt = $db->query("SELECT * FROM contabo_settings LIMIT 1");
    $settings = $stmt->fetch(PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    // Table might not exist yet
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contabo API Settings</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 600px; margin: 50px auto; padding: 20px; }
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; font-weight: bold; }
        input[type="text"], input[type="password"] { width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px; }
        button { background: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer; }
        .message { padding: 10px; margin: 10px 0; border-radius: 4px; }
        .success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .error { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
    </style>
</head>
<body>
    <h1>Contabo API Settings</h1>
    
    <?php if ($message): ?>
        <div class="message success"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>
    
    <?php if ($error): ?>
        <div class="message error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    
    <form method="POST">
        <div class="form-group">
            <label for="client_id">Client ID:</label>
            <input type="text" id="client_id" name="client_id" 
                   value="<?php echo htmlspecialchars($settings['client_id'] ?? ''); ?>" required>
        </div>
        
        <div class="form-group">
            <label for="client_secret">Client Secret:</label>
            <input type="password" id="client_secret" name="client_secret" 
                   value="<?php echo htmlspecialchars($settings['client_secret'] ?? ''); ?>" required>
        </div>
        
        <div class="form-group">
            <label for="api_user">API User:</label>
            <input type="text" id="api_user" name="api_user" 
                   value="<?php echo htmlspecialchars($settings['api_user'] ?? ''); ?>" required>
        </div>
        
        <div class="form-group">
            <label for="api_password">API Password:</label>
            <input type="password" id="api_password" name="api_password" 
                   value="<?php echo htmlspecialchars($settings['api_password'] ?? ''); ?>" required>
        </div>
        
        <button type="submit">Save Settings</button>
    </form>
    
    <p><a href="view_vps.php">View VPS Instances</a></p>
</body>
</html>